/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.registry.natives;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.natives.IBakedTypeInfo;
import com.blamejared.crafttweaker.api.natives.IExecutableReferenceInfo;
import com.blamejared.crafttweaker.api.natives.INativeTypeRegistry;
import com.blamejared.crafttweaker.api.natives.NativeTypeInfo;
import com.blamejared.crafttweaker.impl.registry.natives.BakedTypeInfo;
import com.blamejared.crafttweaker.impl.registry.natives.ExecutableReferenceGroupInfo;
import com.blamejared.crafttweaker.impl.registry.natives.ExecutableReferenceInfo;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public final class NativeTypeRegistry
implements INativeTypeRegistry {
    private final Map<Class<?>, BakedTypeInfo> info = new HashMap();
    private final Collection<IBakedTypeInfo> valuesView = Collections.unmodifiableCollection(this.info.values());

    private static Class<?>[] convertConstructorToClassArray(NativeTypeInfo.Constructor constructorInfo) {
        return NativeTypeRegistry.convertParametersToClassArray(constructorInfo.parameters());
    }

    private static Class<?>[] convertMethodToClassArray(NativeTypeInfo.Method methodInfo) {
        return NativeTypeRegistry.convertParametersToClassArray(methodInfo.parameters());
    }

    private static Class<?>[] convertParametersToClassArray(NativeTypeInfo.Parameter ... parametersInfo) {
        return (Class[])Arrays.stream(parametersInfo).map(NativeTypeInfo.Parameter::type).toArray(Class[]::new);
    }

    public void addNativeType(NativeTypeInfo info) {
        Class<?> targetedType = info.targetedType();
        String zenName = info.name();
        BakedTypeInfo knownData = this.info.get(targetedType);
        if (knownData != null && !knownData.zenName().equals(zenName)) {
            CraftTweakerAPI.LOGGER.error("Trying to register native type '{}' twice with names (old) '{}' and (new) '{}'", (Object)targetedType.getName(), (Object)knownData.zenName(), (Object)zenName);
            return;
        }
        Map<String, ExecutableReferenceGroupInfo> executables = this.getExecutableInfo(info);
        this.info.put(targetedType, new BakedTypeInfo(zenName, targetedType, executables));
    }

    public void inheritFrom(NativeTypeRegistry other) {
        other.info.forEach((clazz, info) -> {
            if (this.info.containsKey(clazz)) {
                throw new IllegalStateException("Unable to duplicate native type data for " + clazz);
            }
            this.info.put((Class<?>)clazz, (BakedTypeInfo)info);
        });
    }

    private Map<String, ExecutableReferenceGroupInfo> getExecutableInfo(NativeTypeInfo info) {
        HashMap<String, ExecutableReferenceGroupInfo> result = new HashMap<String, ExecutableReferenceGroupInfo>();
        Arrays.stream(info.constructors()).forEach(it -> {
            Class<?>[] parameters = NativeTypeRegistry.convertConstructorToClassArray(it);
            result.computeIfAbsent("<init>", i -> new ExecutableReferenceGroupInfo()).getOrCreateFor(parameters, ExecutableReferenceInfo.AnnotationCreator::appendConstructorAnnotation);
        });
        Arrays.stream(info.methods()).forEach(it -> result.computeIfAbsent(it.name(), i -> new ExecutableReferenceGroupInfo()).getOrCreateFor(NativeTypeRegistry.convertMethodToClassArray(it), cons -> {
            cons.appendGetterAnnotation(it.getter());
            cons.appendSetterAnnotation(it.setter());
            cons.appendMethodAnnotation();
        }));
        return result;
    }

    @Override
    public Optional<String> getZenNameFor(Class<?> clazz) {
        return this.getBakedTypeInfoFor(clazz).map(IBakedTypeInfo::zenName);
    }

    @Override
    public Collection<IBakedTypeInfo> getBakedTypeInfo() {
        return this.valuesView;
    }

    @Override
    public Optional<IBakedTypeInfo> getBakedTypeInfoFor(Class<?> clazz) {
        return Optional.ofNullable((IBakedTypeInfo)this.info.get(clazz));
    }

    @Override
    public Optional<IExecutableReferenceInfo> getExecutableReferenceInfoFor(Constructor<?> constructor) {
        return this.getBakedTypeInfoFor(constructor.getDeclaringClass()).flatMap(it -> it.findMethod(constructor));
    }

    @Override
    public Optional<IExecutableReferenceInfo> getExecutableReferenceInfoFor(Method method) {
        return this.getBakedTypeInfoFor(method.getDeclaringClass()).flatMap(it -> it.findMethod(method));
    }
}

